/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.mixins.accessors.MinecraftAccessor;
import club.sk1er.patcher.screen.render.overlay.metrics.MetricsData;
import java.awt.Dimension;
import java.awt.Toolkit;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class MinecraftHook {
    public static final MinecraftHook INSTANCE = new MinecraftHook();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final MinecraftAccessor minecraftAccessor = (MinecraftAccessor)mc;
    private boolean lastFullscreen = false;
    public static MetricsData metricsData;

    public static boolean fullscreen() {
        if (!PatcherConfig.instantFullscreen || !PatcherConfig.windowedFullscreen || Util.func_110647_a() != Util.EnumOS.WINDOWS) {
            return false;
        }
        minecraftAccessor.setFullScreen(!mc.func_71372_G());
        boolean grabbed = Mouse.isGrabbed();
        if (grabbed) {
            Mouse.setGrabbed((boolean)false);
        }
        try {
            DisplayMode displayMode = Display.getDesktopDisplayMode();
            if (mc.func_71372_G()) {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "true");
                Display.setDisplayMode((DisplayMode)displayMode);
                Display.setLocation((int)0, (int)0);
            } else {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "false");
                displayMode = new DisplayMode(minecraftAccessor.getTempDisplayWidth(), minecraftAccessor.getTempDisplayHeight());
                Display.setDisplayMode((DisplayMode)displayMode);
                MinecraftHook.displayCommon();
            }
            Display.setFullscreen((boolean)false);
            MinecraftHook.mc.field_71443_c = displayMode.getWidth();
            MinecraftHook.mc.field_71440_d = displayMode.getHeight();
            if (MinecraftHook.mc.field_71462_r != null) {
                mc.func_71370_a(MinecraftHook.mc.field_71443_c, MinecraftHook.mc.field_71440_d);
            } else {
                minecraftAccessor.invokeUpdateFramebufferSize();
            }
            MinecraftHook.INSTANCE.lastFullscreen = mc.func_71372_G();
            mc.func_175601_h();
            Mouse.setCursorPosition((int)(Display.getX() + Display.getWidth() >> 1), (int)(Display.getY() + Display.getHeight() >> 1));
            if (grabbed) {
                Mouse.setGrabbed((boolean)true);
            }
            Display.setResizable((boolean)false);
            Display.setResizable((boolean)true);
            return true;
        }
        catch (LWJGLException e) {
            Patcher.instance.getLogger().error("Failed to toggle fullscreen.", (Throwable)e);
            return false;
        }
    }

    private static void displayCommon() {
        Display.setResizable((boolean)false);
        Display.setResizable((boolean)true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)Display.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)Display.getHeight()) / 2.0);
        Display.setLocation((int)x, (int)y);
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !PatcherConfig.windowedFullscreen) {
            return;
        }
        boolean fullScreenNow = Minecraft.func_71410_x().func_71372_G();
        if (this.lastFullscreen != fullScreenNow) {
            this.fix(fullScreenNow);
            this.lastFullscreen = fullScreenNow;
        }
    }

    public void fix(boolean fullscreen) {
        try {
            if (fullscreen) {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "true");
                Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                Display.setLocation((int)0, (int)0);
                Display.setFullscreen((boolean)false);
            } else {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "false");
                Display.setDisplayMode((DisplayMode)new DisplayMode(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d));
                MinecraftHook.displayCommon();
            }
            Display.setResizable((!fullscreen ? 1 : 0) != 0);
        }
        catch (LWJGLException e) {
            Patcher.instance.getLogger().error("Failed to update screen type.", (Throwable)e);
        }
    }
}

